ActiveText = copy_table(Shape)

function ActiveText:init(def, view)
    Shape.init(self, def, view, true)

    self.font = def.font
    self.align = def.align
    self.alpha = def.alpha or 1
    self.color = def.color

    self.color_hi = def.color_hi
    self.highlight_on = true
    self:set_text(def.text or "")
    
    self.click_sound = def.click_sound or "button_click"
    self.highlight_sound = def.highlight_sound or "button_highlight"
end


function ActiveText:set_text(text)
    self.text = text
    self.w, self.h = gfx_text_size(self.font, self.text, self.align)
    self:create_area()
end


function ActiveText:render()
    if self.hi_alpha > 0 then
        gfx_render_text(self.font, self.x, self.y, self.text, self.align, self.w, self.h, self.alpha, self.color_hi)
    else
        gfx_render_text(self.font, self.x, self.y, self.text, self.align, self.w, self.h, self.alpha, self.color)
    end
end


function ActiveText:mouse_in()
    snd_play_sound(self.highlight_sound)
end


function ActiveText:mouse_left_click()
    snd_play_sound(self.click_sound)
end

